#ifndef HAPTICDEVICE_H
#define HAPTICDEVICE_H

#include "hapticdevicecustom.h"

#include <HD/hd.h>
#include <HDU/hduVector.h>
#include <HDU/hduError.h>


#include "calc.h"
#include "hapticsoundcustom.h"

/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Config and control Haptic device  
*
*	 Config and control Haptic device
*/

class HapticDevice: public HapticDeviceCustom
{
private:
	HDSchedulerHandle hUpdateHandle;
	HHD hHD;
public:
	HapticDevice(TCalc* aCalc, HapticSoundCustom* aHapticSoundCustom);


	void setMultByLengthA( double value );
	void setMaxForceA( double value );
	void setLengthA( double value );
	void setGridGrowA( double value );
	void setMultByLengthB( double value );
	void setMaxForceB( double value );
	void setLengthB( double value );
	void setGridGrowB( double value );
	void setGridOffset( double value );
	void setGridSpace( double value );
	void setGridHeight( double value );
	void setScale( double value );
	void setSlowPath( double value );
	void setMarginX( double value );
	void setMarginY( double value );
	void setGridEnabled( bool value ); 
	void setOffestHaptic( double value[3] );



	double getGridSpace();
	double getScale();
	bool getGridEnabled();


	~HapticDevice();

	void UpdateData();
	void CenterDevice();

};


#endif
