#ifndef HAPTICSTATUS_H
#define HAPTICSTATUS_H

#include <QtGui>

#include "hapticdevicecustom.h"
#include "calc.h"

/*! \author Magni Thor Birgisson mthb1@hi.is
*   \brief Dialog class to see current Information about Haptic Device
*
*	This class ...
*/

class frmStatus : public QDialog
{
	Q_OBJECT
public:
	frmStatus(QWidget * parent = 0, Qt::WFlags f = 0);
	~frmStatus();
	void setCalc( TCalc* aCalc );
	void setDevice( HapticDeviceCustom* aHapticDevice );
	void WriteLog(QString aValue);


public slots:
    void updateList();

private:
	QLabel* m_lblState;
	QLabel* m_lblPos;
	QLabel* m_lblForce;
	QLabel* m_lblButton;
	QLabel* m_lblVector;
	QLabel* m_lblPath;
	QLabel* m_lblGrid;
	
	TCalc* m_Calc;
	HapticDeviceCustom* m_HapticDevice;
};

#endif
