#include "frmstatus.h"
#include <stdio.h>
#include <time.h>
#include <sys/time.h>

const
	char* cFileLog = "LogFile.txt";

frmStatus::frmStatus(QWidget * parent, Qt::WFlags f):
QDialog( parent, f )
{
	m_Calc = 0;
	setWindowTitle( tr("Haptic Status") );
	QVBoxLayout *Layout = new QVBoxLayout(this);
	m_lblState = new QLabel("", this);
	m_lblPos = new QLabel("", this);
	m_lblForce = new QLabel("", this);
	m_lblVector = new QLabel("", this);
	m_lblButton = new QLabel("", this);
	m_lblPath = new QLabel("", this);
	m_lblGrid = new QLabel("", this);
	Layout->addWidget( m_lblState );
	Layout->addWidget( m_lblPos );
	Layout->addWidget( m_lblForce );
	Layout->addWidget( m_lblVector );
	Layout->addWidget( m_lblButton );
	Layout->addWidget( m_lblPath );
	Layout->addWidget( m_lblGrid );
}

frmStatus::~frmStatus()
{
}

void frmStatus::setDevice( HapticDeviceCustom* aHapticDevice )
{
	m_HapticDevice = aHapticDevice;
}


void frmStatus::setCalc( TCalc* aCalc )
{
	m_Calc = aCalc;
}

void frmStatus::updateList()
{
     //std::cout << aHapticDevice->gServoDeviceData->m_devicePosition[0] << std::endl;
	QString s;
	HapticDeviceData* currentHapticDeviceData = m_HapticDevice->currentHapticDeviceData;
	
	if (currentHapticDeviceData->m_iState == 0)
		s.sprintf("State A");
	else if (currentHapticDeviceData->m_iState == 1)
		s.sprintf("State B");
	else 
		s.sprintf("State unknown");
	m_lblState->setText( s );
	
	s.sprintf("Pos (%.2f, %.2f, %.2f)  ",
			currentHapticDeviceData->m_devicePosition[0],
			currentHapticDeviceData->m_devicePosition[1],
			currentHapticDeviceData->m_devicePosition[2]);
	m_lblPos->setText( s );

	s.sprintf("Force (%.2f, %.2f, %.2f)  ",
			currentHapticDeviceData->m_force[0],
			currentHapticDeviceData->m_force[1],
			currentHapticDeviceData->m_force[2]);
	m_lblForce->setText( s );


	if (m_Calc != 0)
	{
		s.sprintf("Vector (%.2f, %.2f)  ",
			m_Calc->LastdToGraphX,
			m_Calc->LastdToGraphY);
		m_lblVector->setText( s );
	}


     if (currentHapticDeviceData->m_buttonState) 
          m_lblButton->setText( "Button click" );
     else
          m_lblButton->setText( "Button not clicked" );


	s.sprintf("Pos on path (%.2f, %.2f) ",
			currentHapticDeviceData->m_path[0],
			currentHapticDeviceData->m_path[1]);
	m_lblPath->setText( s );

	s.sprintf("Pos on Grid (%.2f, %.2f) ",
			currentHapticDeviceData->m_grid[0],
			currentHapticDeviceData->m_grid[1]);
	m_lblGrid->setText( s );

////////////////////////// FileLog

	

	s.sprintf("%d\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%.2f\t%d",
		currentHapticDeviceData->m_iState,
		currentHapticDeviceData->m_devicePosition[0],
		currentHapticDeviceData->m_devicePosition[1],
		currentHapticDeviceData->m_devicePosition[2],
		currentHapticDeviceData->m_force[0],
		currentHapticDeviceData->m_force[1],
		currentHapticDeviceData->m_force[2],
		currentHapticDeviceData->m_path[0],
		currentHapticDeviceData->m_path[1],
		m_Calc->LastdToGraphX,
		m_Calc->LastdToGraphY,
		currentHapticDeviceData->m_buttonState);
	
	WriteLog(s);

}

void frmStatus::WriteLog(QString aValue)
{
	FILE * pFile;
	pFile = fopen(cFileLog, "a");
	if (pFile!=NULL)
	{

		struct timeval tv;

		time_t curtime;

		gettimeofday(&tv, NULL); 
		curtime=tv.tv_sec;
		//tv.tv_usec;
		struct tm  ts = *localtime(&curtime);

		//time_t curtime;
		tm * ptm;
	
		//time ( &curtime );
		//struct tm  ts = *localtime(&curtime);
		
	
		ptm = gmtime ( &curtime );
			
		int imSec = (int)  (tv.tv_usec / 10000);

		QString strTime;
		strTime.sprintf("%d:%d:%d:%d\t", ptm->tm_hour, ptm->tm_min, ptm->tm_sec, imSec);
		aValue = strTime + aValue + "\n";

		fputs(aValue.toAscii().data(), pFile);
		fclose(pFile);
	}
}

