#include"frmmain.h"

#include "filequit.xpm"


frmMainWindow::frmMainWindow()
{
	m_Calc = new TCalc();

	m_HapticSound = new HapticSound();

	m_HapticDevice =  new HapticDevice( m_Calc, m_HapticSound );

	m_frmStatus = new frmStatus();
	m_frmStatus->setDevice( m_HapticDevice );
	m_frmStatus->setCalc( m_Calc );
		
	m_frmGraph = new frmGraph();
	m_frmGraph->setCalc( m_Calc );
	m_frmGraph->setDevice( m_HapticDevice );
	
	m_frmCustom = new frmCustom();
	m_frmCustom->setDevice( m_HapticDevice, m_HapticSound );
	
	
	/////////////////
	
	m_frmStatus->WriteLog( QString("Run") );

	setWindowTitle( tr("Haptic") );
	
	
	m_Timer = new QTimer( this );
	connect( m_Timer, SIGNAL( timeout() ), SLOT( OnTimeTicked() ) );
	
	QPixmap quitProgram;
	
	QToolBar * fileTools = new QToolBar( "File Operations",  this );
	
	
	quitProgram = QPixmap( filequit );
	
	connect( fileTools->addAction( quitProgram, tr("Quit") ), SIGNAL(changed()), this, SLOT(toggle_HapticStatus()));
		
	QToolButton * filequit = new QToolButton( );
	fileTools->addWidget(filequit);
	filequit->setIcon( quitProgram );
	connect(filequit,  SIGNAL(pressed()), qApp, SLOT(closeAllWindows()));

	//	= new QToolButton( quitProgram, tr("Quit"), QString::null,	qApp, SLOT(closeAllWindows()), fileTools, "filequit" );
	/*
	
	(void)QWhatsThis::whatsThisButton( fileTools );
	
	QString fileQuitText = tr("<p><img source=\"filequit\"> "
			"Click this button to quit. <br>"
			"You can also select the <b>Quit</b> command "
			"from the <b>File</b> menu.</p>");
	
	QWhatsThis::add( filequit, fileQuitText );
	QMimeSourceFactory::defaultFactory()->setPixmap( "filequit", quitProgram );
	*/

	QMenu *fileMenu = menuBar()->addMenu( tr("&File") );


	//fileMenu->addSeparator();

	QAction *exitAct = new QAction(tr("E&xit"), this);
	exitAct->setShortcut(tr("Ctrl+Q"));
	exitAct->setStatusTip(tr("Exit the application"));
	connect(exitAct, SIGNAL(triggered()), qApp, SLOT(closeAllWindows()));
	fileMenu->addAction( exitAct );



	QMenu *windowMenu = menuBar()->addMenu( tr("&Windows") );

	connect( windowMenu, SIGNAL( aboutToShow() ), SLOT( updateWindowMenu() ) );
	
	m_MenuStatus = new QAction(  tr("Haptic Status"), this );
	m_MenuStatus->setCheckable( true );
	connect( m_MenuStatus, SIGNAL(triggered()), this, SLOT(toggle_HapticStatus()) );
	windowMenu->addAction( m_MenuStatus );
	
	m_MenuGraph = new QAction( tr("Haptic Graph"), this );
	m_MenuGraph->setCheckable( true );
	connect( m_MenuGraph, SIGNAL(triggered()), this, SLOT(toggle_HapticGraph()) );
	windowMenu->addAction( m_MenuGraph );

	m_MenuCustom = new QAction( tr("Haptic Custom"), this );
	m_MenuCustom->setCheckable( true );
	connect( m_MenuCustom, SIGNAL(triggered()), this, SLOT(toggle_HapticCustom()) );
	windowMenu->addAction( m_MenuCustom );




	QMenu *helpMenu = menuBar()->addMenu( tr("Help") );
	m_ItemAbout = new QAction( tr("About"), this);
	m_ItemAbout->setStatusTip(tr("Show the application's About box"));
	connect( m_ItemAbout, SIGNAL(triggered()), this, SLOT(ItemClickAbout()) );
	
	helpMenu->addAction( m_ItemAbout );
	//help->insertItem( tr("&About"), this, SLOT(about()), Key_F1 );
	//help->insertSeparator();
	//help->insertItem( tr("What's &This"), this, SLOT(whatsThis()), SHIFT+Key_F1 );
	
	QWidget* box = new QWidget(this);
	QVBoxLayout* vLayout = new QVBoxLayout;
	QHBoxLayout* layout = new QHBoxLayout;
	vLayout->addItem(layout);
	layout->addWidget(new QLabel(tr("Formula")));
	layout->addSpacing(12);
	m_ledFormula = new QLineEdit();
	connect( m_ledFormula, SIGNAL( returnPressed() ), SLOT(OnCalcClick()) );	
	layout->addWidget(m_ledFormula);
	layout->addSpacing(12);
	QPushButton* Button = new QPushButton(  );
	layout->addWidget(Button);
	Button->setText( tr("Calc") );
	connect( Button, SIGNAL( pressed() ), SLOT(OnCalcClick()));

	layout = new QHBoxLayout;
	vLayout->addItem(layout);
	m_LogTag = new QLineEdit();
	layout->addWidget(m_LogTag);
	layout->addSpacing(12);
	Button = new QPushButton();
	layout->addWidget(Button);
	layout->addSpacing(12);
	Button->setText( tr("Begin") );
	connect( Button, SIGNAL( pressed() ), SLOT(OnLogBeginClick()));
	Button = new QPushButton();
	layout->addWidget(Button);
	layout->addSpacing(12);
	Button->setText( tr("Tuch the paper") );
	connect( Button, SIGNAL( pressed() ), SLOT(OnLogTouchClick()));
	Button = new QPushButton();
	layout->addWidget(Button);
	Button->setText( tr("End") );
	connect( Button, SIGNAL( pressed() ), SLOT(OnLogEndClick()));

	box->setLayout(vLayout);
	setCentralWidget( box );
	
	if (m_HapticDevice != 0)
		LoadXML();
		
	statusBar()->showMessage( tr("Ready"), 2000 );
	
	resize( 600, 150 );
	move( 0, 25 );

	m_ledFormula->setFocus();
	
	m_iTimeCount=0;
	if (m_HapticDevice != 0)
		m_Timer->start( 30 );

	m_frmGraph->show();
	m_frmGraph->move( 0, 220 );
	m_frmStatus->show();
	m_frmStatus->move( 650, 25);
	
	m_frmCustom->show();
	m_frmCustom->move( 650, 280);

}

frmMainWindow::~frmMainWindow()
{
	m_frmStatus->WriteLog( QString("Close") );
	m_Timer->stop();
	delete m_frmStatus;
	delete m_frmGraph;
	delete m_frmCustom;
	delete m_HapticSound;
	if (m_HapticDevice != 0)
		delete m_HapticDevice; 
}

void frmMainWindow::LoadXML()
{
	statusBar()->showMessage( tr("Load XML"), 2000 );
	
	//Load XML
	QString fileName = "config.xml";
	QFile file(fileName);
	if (!file.open(QFile::ReadOnly | QFile::Text)) 
	{
		QMessageBox::warning(this, tr("Haptic - XML config"),
                                 tr("Cannot read file %1:\n%2.")
                                 .arg(QDir::currentPath () + "/" + fileName)
                                 .arg(file.errorString()));
	

	}
	else
	{
		QDomDocument domDocument;
		QString errorStr;
        int errorLine;
        int errorColumn;

        if (!domDocument.setContent(&file, true, &errorStr, &errorLine, &errorColumn)) 
		{
            QMessageBox::information(this, tr("Haptic - XML config"),
                                     tr("Parse error at line %1, column %2:\n%3")
                                     .arg(errorLine)
                                     .arg(errorColumn)
                                     .arg(errorStr));
		}
		else
		{
			m_frmCustom->LoadFromXML( domDocument );
			
		}
	}
}

void frmMainWindow::OnTimeTicked()
{
	bool bUpdateHapticData = false;

	if ((int)(m_iTimeCount % 1) == 0)	// Update data and stuff half the time
	{
		m_HapticDevice->UpdateData();
		m_frmStatus->updateList();
		bUpdateHapticData = true;
	}

	if ((int)(m_iTimeCount % 15) == 0)	// Repaint only once in every 16 steps
	{
		if (bUpdateHapticData)
		{
			m_frmStatus->updateList();
			bUpdateHapticData = true;
		}
		m_frmGraph->repaint();
	}


	m_iTimeCount++;
	if (m_iTimeCount == 30000)		// Just to keep some integer boundarys for the counter
		m_iTimeCount = 0;
}

void frmMainWindow::OnCalcClick()
{
	QString strText = m_ledFormula->text();
	m_Calc->setFormula( strText.toAscii().data());
	//strText.
	double aResult;
	m_Calc->CleanGraphPath();
	if (m_Calc->Calc( aResult ))
	{
		m_Calc->MakeGraphPath(-220*m_HapticDevice->getScale(), 220*m_HapticDevice->getScale(), 
			-220*m_HapticDevice->getScale(), 220*m_HapticDevice->getScale(), 
			0.01*m_HapticDevice->getScale());
		if (!m_frmGraph->isHidden())
			m_frmGraph->repaint();
		strText.setNum( aResult );
	}
	else
		strText = tr("Error");
	statusBar()->showMessage( strText );
	strText = m_ledFormula->text();
	strText = "Change Formula " + strText + "\t";
	
	if (m_HapticSound->getGridPitchSound())
		strText	= strText + "T\t";
	else
		strText	= strText + "F\t";
	if (m_HapticSound->getGridTickSound())
		strText	= strText + "T\t";
	else
		strText	= strText + "F\t";
	if (m_HapticSound->getOnPathSound())
		strText	= strText + "T\t";
	else
		strText	= strText + "F\t";
	if (m_HapticSound->getOnVoicePathSound())
		strText	= strText + "T\t";
	else
		strText	= strText + "F\t";
	if (m_HapticDevice->getGridEnabled())
		strText	= strText + "T";
	else
		strText	= strText + "F";



	m_frmStatus->WriteLog( strText  );
}

void frmMainWindow::OnLogBeginClick()
{
	m_frmStatus->WriteLog( QString("XXX Begin ") + m_LogTag->text());
}
void frmMainWindow::OnLogTouchClick()
{
	m_frmStatus->WriteLog(QString("XX Touch ") + m_LogTag->text());
}

void frmMainWindow::OnLogEndClick()
{
	m_frmStatus->WriteLog(QString("XXX End ") + m_LogTag->text());
}


void frmMainWindow::closeEvent( QCloseEvent* ce )
{
    ce->accept();
}

void frmMainWindow::hideEvent( QHideEvent *  )
{
	if (!isVisible())
		qApp->closeAllWindows();
}


void frmMainWindow::ItemClickAbout()
{
    QMessageBox::about( this, tr("Haptic"),
			tr("Function of Hapitc. "));
}

void frmMainWindow::updateWindowMenu()
{
    m_MenuStatus->setChecked(  !m_frmStatus->isHidden() );
	m_MenuGraph->setChecked( !m_frmGraph->isHidden() );
	m_MenuCustom->setChecked( !m_frmCustom->isHidden() );
	
}

void frmMainWindow::toggle_HapticStatus()
{
    if (m_frmStatus->isHidden())
        m_frmStatus->show();
    else
        m_frmStatus->hide();
}

void frmMainWindow::toggle_HapticGraph()
{
	if (m_frmGraph->isHidden())
		m_frmGraph->show();
	else
		m_frmGraph->hide();
}

void frmMainWindow::toggle_HapticCustom()
{
	if (m_frmCustom->isHidden())
		m_frmCustom->show();
	else
		m_frmCustom->hide();
}


