#include "frmcustom.h"


frmCustom::frmCustom(QWidget * parent, Qt::WFlags f):
QDialog( parent, f )
{
	QTabWidget *tabWidget = new QTabWidget;
	m_widTapDevice = new widTapDevice(this, f);
	m_widTapSound = new widTapSound(this, f);
	m_widTapLog = new widTapLog(this, f);
	
	tabWidget->addTab( m_widTapDevice, tr("Haptic Device") );
	tabWidget->addTab( m_widTapSound, tr("Sound") );
	tabWidget->addTab( m_widTapLog, tr("Log") );

	
	QPushButton *ApplyButton = new QPushButton(tr("&Apply"));
	QPushButton *DefaultButton = new QPushButton(tr("Default"));

	connect(ApplyButton, SIGNAL(clicked()), this, SLOT(OnApplyClick()));
	connect(DefaultButton, SIGNAL(clicked()), this, SLOT(OnDefaultClick()));

	
	QHBoxLayout *buttonLayout = new QHBoxLayout;
	buttonLayout->addStretch(1);
	buttonLayout->addWidget(DefaultButton);
	buttonLayout->addWidget(ApplyButton);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(tabWidget);
	mainLayout->addLayout(buttonLayout);
	
	setLayout(mainLayout);
	setWindowTitle(tr("Haptic Custom"));
 
}


frmCustom::~frmCustom()
{
}

void frmCustom::LoadFromXML( QDomDocument &domDocument )
{
	m_widTapDevice->LoadFromXML(domDocument);
	m_widTapSound->LoadFromXML(domDocument);
	OnApplyClick();
}

void frmCustom::SaveToXML( QDomDocument &domDocument )
{
	m_widTapDevice->SaveToXML(domDocument);
}

void frmCustom::setDevice( HapticDeviceCustom* aHapticDevice, HapticSoundCustom* aHapticSound )
{
	m_widTapDevice->setDevice(aHapticDevice, aHapticSound);
	m_widTapSound->setDevice(aHapticDevice, aHapticSound);
}

void frmCustom::OnDefaultClick()
{
	m_widTapDevice->OnDefaultClick();
	m_widTapSound->OnDefaultClick();
}

void frmCustom::OnApplyClick()
{
	m_widTapDevice->OnApplyClick();
	m_widTapSound->OnApplyClick();
}


///////////////////////////

void UpdateQCheckBox(QCheckBox* CheckBox, QDomElement &HapticChild)
{
	if (HapticChild.hasAttribute("Value"))
	{
		int iCompare = QString::compare( HapticChild.attribute("Value").toLower(), "false" );
		if (iCompare == 0)
			CheckBox->setCheckState( Qt::Unchecked );
		else
			CheckBox->setCheckState( Qt::Checked );
	}
}

void UpdateQDoubleSpinBox(QDoubleSpinBox* SpinBox, QDomElement &HapticChild)
{
	double dValue;
	bool ok;
	if (HapticChild.hasAttribute("Value"))
	{
		dValue = HapticChild.attribute("Value").toDouble(&ok);
		if (ok)
			SpinBox->setValue( dValue );
	}
	if (HapticChild.hasAttribute("Max"))
	{
		dValue = HapticChild.attribute("Max").toDouble(&ok);
		if (ok)
			SpinBox->setMaximum( dValue );
	}
	if (HapticChild.hasAttribute("Min"))
	{
		dValue = HapticChild.attribute("Min").toDouble(&ok);
		if (ok)
			SpinBox->setMinimum( dValue );
	}
	if (HapticChild.hasAttribute("SingleStep"))
	{
		dValue = HapticChild.attribute("SingleStep").toDouble(&ok);
		if (ok)
			SpinBox->setSingleStep( dValue );
	}
	if (HapticChild.hasAttribute("Decimals"))
	{
		dValue = HapticChild.attribute("Decimals").toDouble(&ok);
		if (ok)
			SpinBox->setDecimals( (int)dValue );
	}
}

///////////////

widTapDevice::widTapDevice(QWidget * parent, Qt::WFlags f):
QWidget( parent, f )
{
	m_MultByLengthA = new QDoubleSpinBox();
	m_MaxForceA = new QDoubleSpinBox();
	m_LengthA = new QDoubleSpinBox();
	m_GridGrowA = new QDoubleSpinBox();
	
	m_MultByLengthB = new QDoubleSpinBox();
	m_MaxForceB = new QDoubleSpinBox();
	m_LengthB = new QDoubleSpinBox();
	m_GridGrowB = new QDoubleSpinBox();
	
	m_GridOffset = new QDoubleSpinBox();
	m_GridSpace = new QDoubleSpinBox();
	m_GridHeight = new QDoubleSpinBox();
	m_Scale = new QDoubleSpinBox();
	m_SlowPath = new QDoubleSpinBox();
	m_MarginX = new QDoubleSpinBox();
	m_MarginY = new QDoubleSpinBox();
	m_GridOn = new QCheckBox();
	
	m_CenterDevice = new QPushButton();
	m_CenterDevice->setText( tr("Center") );
	
	connect(m_MultByLengthA, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_MaxForceA, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_LengthA, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_GridGrowA, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double))); 
	
	connect(m_MultByLengthB, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_MaxForceB, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_LengthB, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_GridGrowB, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	
	connect(m_GridOffset, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_GridSpace, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_GridHeight, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_Scale, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_SlowPath, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_MarginX, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	connect(m_MarginY, SIGNAL(valueChanged(double)), this, SLOT(OnChange(double)));
	
	connect( m_CenterDevice, SIGNAL( pressed() ), SLOT(OnCenterDeviceClick()));	
	
	QGridLayout *controlsLayout = new QGridLayout;
	int iLine = 0;

	controlsLayout->addWidget(new QLabel(tr("A")), iLine, 1);
	controlsLayout->addWidget(new QLabel(tr("B")), iLine, 2);
	iLine++;
		
	controlsLayout->addWidget(new QLabel(tr("Mult By Length value:")), iLine, 0);
	controlsLayout->addWidget(m_MultByLengthA, iLine, 1);
	controlsLayout->addWidget(m_MultByLengthB, iLine, 2);
	iLine++;
	
	controlsLayout->addWidget(new QLabel(tr("Max Force value:")), iLine, 0);
	controlsLayout->addWidget(m_MaxForceA, iLine, 1);
	controlsLayout->addWidget(m_MaxForceB, iLine, 2);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Length value:")), iLine, 0);
	controlsLayout->addWidget(m_LengthA, iLine, 1);
	controlsLayout->addWidget(m_LengthB, iLine, 2);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Grid grow value:")), iLine, 0);
	controlsLayout->addWidget(m_GridGrowA, iLine, 1);
	controlsLayout->addWidget(m_GridGrowB, iLine, 2);
	iLine++;

	
	iLine++;
	controlsLayout->addWidget(new QLabel(tr("Global")), iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Scale value:")), iLine, 0);
	controlsLayout->addWidget(m_Scale, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Grid offset value:")), iLine, 0);
	controlsLayout->addWidget(m_GridOffset, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Grid height value:")), iLine, 0);
	controlsLayout->addWidget(m_GridHeight, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Grid space value:")), iLine, 0);
	controlsLayout->addWidget(m_GridSpace, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Slow Path value:")), iLine, 0);
	controlsLayout->addWidget(m_SlowPath, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("MarginX value:")), iLine, 0);
	controlsLayout->addWidget(m_MarginX, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("MarginY value:")), iLine, 0);
	controlsLayout->addWidget(m_MarginY, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Grid Enabled:")), iLine, 0);
	controlsLayout->addWidget(m_GridOn, iLine, 1);
	iLine++;

	controlsLayout->addWidget(new QLabel(tr("Center Deivce:")), iLine, 0);
	controlsLayout->addWidget(m_CenterDevice, iLine, 1);
	iLine++;


	this->setLayout(controlsLayout);
}

void widTapDevice::OnChange( double )
{
}

void widTapDevice::LoadFromXML( QDomDocument &domDocument )
{
	QDomElement root = domDocument.documentElement();
	QDomElement child = root.firstChildElement("HapticDevice");
	QDomElement HapticChild;
	QString tagName;
	
	while (!child.isNull()) 
	{
		HapticChild = child.firstChildElement();
		while (!HapticChild.isNull())
		{
			tagName = HapticChild.tagName();
			if (tagName == "Scale")
				UpdateQDoubleSpinBox(m_Scale, HapticChild);
			else if (tagName == "GridOffset")
				UpdateQDoubleSpinBox(m_GridOffset, HapticChild);
			else if (tagName == "GridSpace")
				UpdateQDoubleSpinBox(m_GridSpace, HapticChild);
			else if (tagName == "GridHeight")
				UpdateQDoubleSpinBox(m_GridHeight, HapticChild);
			else if (tagName == "MultByLengthA")
				UpdateQDoubleSpinBox(m_MultByLengthA, HapticChild);
			else if (tagName == "MaxForceA")
				UpdateQDoubleSpinBox(m_MaxForceA, HapticChild);
			else if (tagName == "LengthA")
				UpdateQDoubleSpinBox(m_LengthA, HapticChild);
			else if (tagName == "GridGrowA")
				UpdateQDoubleSpinBox(m_GridGrowA, HapticChild);
			else if (tagName == "MultByLengthB")
				UpdateQDoubleSpinBox(m_MultByLengthB, HapticChild);
			else if (tagName == "MaxForceB")
				UpdateQDoubleSpinBox(m_MaxForceB, HapticChild);
			else if (tagName == "LengthB")
				UpdateQDoubleSpinBox(m_LengthB, HapticChild);
			else if (tagName == "GridGrowB")
				UpdateQDoubleSpinBox(m_GridGrowB, HapticChild);
			else if (tagName == "SlowPath")
				UpdateQDoubleSpinBox(m_SlowPath, HapticChild);
			else if (tagName == "MarginX")
				UpdateQDoubleSpinBox(m_MarginX, HapticChild);
			else if (tagName == "MarginY")
				UpdateQDoubleSpinBox(m_MarginY, HapticChild);
			else if (tagName == "GridEnabled")
				UpdateQCheckBox(m_GridOn, HapticChild);
			
			HapticChild = HapticChild.nextSiblingElement();
		}
		child = child.nextSiblingElement("HapticDevice");
     }
}

void widTapDevice::SaveToXML( QDomDocument &domDocument )
{
	QDomElement root = domDocument.documentElement();
}


void widTapDevice::setDevice( HapticDeviceCustom* aHapticDevice, HapticSoundCustom* )
{
	m_HapticDevice = aHapticDevice;
}

void widTapDevice::OnCenterDeviceClick()
{
	m_HapticDevice->CenterDevice(); 
}

void widTapDevice::OnDefaultClick()
{
}

void widTapDevice::OnApplyClick()
{
	m_HapticDevice->setMultByLengthA( m_MultByLengthA->value() );
	m_HapticDevice->setMaxForceA( m_MaxForceA->value() );
	m_HapticDevice->setLengthA( m_LengthA->value() );
	m_HapticDevice->setGridGrowA( m_GridGrowA->value() );
	m_HapticDevice->setMultByLengthB( m_MultByLengthB->value() );
	m_HapticDevice->setMaxForceB( m_MaxForceB->value() );
	m_HapticDevice->setLengthB( m_LengthB->value() );
	m_HapticDevice->setGridGrowB( m_GridGrowB->value() );

	m_HapticDevice->setGridOffset( m_GridOffset->value() );
	m_HapticDevice->setGridSpace( m_GridSpace->value() );
	m_HapticDevice->setGridHeight( m_GridHeight->value() );
	m_HapticDevice->setScale( m_Scale->value() );
	m_HapticDevice->setSlowPath( m_SlowPath->value() );
	m_HapticDevice->setMarginX( m_MarginX->value() );
	m_HapticDevice->setMarginY( m_MarginY->value() );
	m_HapticDevice->setGridEnabled( m_GridOn->checkState() == Qt::Checked );
}


//////////////

widTapSound::widTapSound(QWidget * parent, Qt::WFlags f):
QWidget( parent, f )
{		
	QGridLayout *controlsLayout = new QGridLayout;
	m_GridTickSound = new QCheckBox();
	m_GridPitchSound = new QCheckBox();
	m_OnPathSound = new QCheckBox();
	m_OnVoicePathSound = new QCheckBox();

	connect( m_GridTickSound, SIGNAL( pressed() ), SLOT(OnChange()));	
	connect( m_GridPitchSound, SIGNAL( pressed() ), SLOT(OnChange()));	
	connect( m_OnPathSound, SIGNAL( pressed() ), SLOT(OnChange()));	
	connect( m_OnVoicePathSound, SIGNAL( pressed() ), SLOT(OnChange()));	


	int iLine = 0;

	controlsLayout->addWidget(new QLabel(tr("Grid Tick Sound:")), iLine, 0);
	controlsLayout->addWidget(m_GridTickSound, iLine, 1);
	iLine++;
	controlsLayout->addWidget(new QLabel(tr("Grid Pitch Sound:")), iLine, 0);
	controlsLayout->addWidget(m_GridPitchSound, iLine, 1);
	iLine++;
	controlsLayout->addWidget(new QLabel(tr("On Path Sound:")), iLine, 0);
	controlsLayout->addWidget(m_OnPathSound, iLine, 1);
	iLine++;
	controlsLayout->addWidget(new QLabel(tr("On Voice Path Sound:")), iLine, 0);
	controlsLayout->addWidget(m_OnVoicePathSound, iLine, 1);
	iLine++;

	this->setLayout(controlsLayout);
}

void widTapSound::setDevice( HapticDeviceCustom* aHapticDevice, HapticSoundCustom* aHapticSound )
{
	m_HapticDevice = aHapticDevice;
	m_HapticSound = aHapticSound;
}


void widTapSound::OnChange()
{
}

void widTapSound::LoadFromXML( QDomDocument &domDocument )
{
	QDomElement root = domDocument.documentElement();
	QDomElement child = root.firstChildElement("HapticSound");
	QDomElement HapticChild;
	QString tagName;
	
	while (!child.isNull()) 
	{
		HapticChild = child.firstChildElement();
		while (!HapticChild.isNull())
		{
			tagName = HapticChild.tagName();
			if (tagName == "GridTickSound")
				UpdateQCheckBox(m_GridTickSound, HapticChild);
			else if (tagName == "GridPitchSound")
				UpdateQCheckBox(m_GridPitchSound, HapticChild);
			else if (tagName == "OnPathSound")
				UpdateQCheckBox(m_OnPathSound, HapticChild);
			else if (tagName == "OnVoicePathSound")
				UpdateQCheckBox(m_OnVoicePathSound, HapticChild);
			
			HapticChild = HapticChild.nextSiblingElement();
		}
		child = child.nextSiblingElement("HapticSound");
     }
}

void widTapSound::SaveToXML( QDomDocument &domDocument )
{
	QDomElement root = domDocument.documentElement();
}

void widTapSound::OnDefaultClick()
{
}

void widTapSound::OnApplyClick()
{
	m_HapticSound->setGridTickSound( m_GridTickSound->checkState() == Qt::Checked );
	m_HapticSound->setGridPitchSound( m_GridPitchSound->checkState() == Qt::Checked );
	m_HapticSound->setOnPathSound( m_OnPathSound->checkState() == Qt::Checked );
	m_HapticSound->setOnVoicePathSound( m_OnVoicePathSound->checkState() == Qt::Checked );
}


//////////////

widTapLog::widTapLog(QWidget * parent, Qt::WFlags f):
QWidget( parent, f )
{		
	QGridLayout *controlsLayout = new QGridLayout;
//	int iLine = 0;

	this->setLayout(controlsLayout);
}

void widTapLog::LoadFromXML( QDomDocument &domDocument )
{
	QDomElement root = domDocument.documentElement();
}

void widTapLog::SaveToXML( QDomDocument &domDocument )
{
	QDomElement root = domDocument.documentElement();
}

void widTapLog::OnDefaultClick()
{
}

void widTapLog::OnApplyClick()
{
}



